#include "/home/brunsch/DAAD/angers/software/develop/dual_residuation/include/lminmaxgd.h"


#include <iostream>
#include <string.h>
#define LONGUEURMAX 2048
#define N 8

using namespace std;

int main(void)
{
try{
    int i,j;
    smatrix au(140,140), aus(140,140), a(140,140), as(140,140),als(140,140);

    // LOAD MATRIX A (provided by CyBio AG
    #include "daten/MatrixA_optimal.h";//smatrix al defined;

    // INCUBATOR
    al(59,139)  = gd(2,0);
    al(0,85)    = gd(1,0);
    // ROBOT I
    al(10,110)  = gd(1,0);
    al(53,134)  = gd(2,0);
    al(105,122) = gd(1,0);
    // ROBOT II
    al(21,69)   = gd(1,0);
    // CYBIWELL
    al(33,104)  = gd(1,0);
    // PEAK CAROUSEL
    al(5,90)    = gd(1,0);
    // SHAKER
    al(111,116) = gd(1,0);
    // READER
    al(123,128) = gd(1,0);

    als = star(al); // \underline{A}^*


    // INITIALIZE MATRIX \overline{A}
    for(i=0;i<140;i++)
    {
        for(j=0;j<140;j++)
        {
            if(i==j)
            {
                au(i,j) = Top;
            }
        }
    }

    // CONSTRAINTS AS GIVEN ON PG. 114
    au(4,135) = gd(2,0);
    au(32,129)=gd(2,0);
    au(96,117)=gd(1,0);
    au(80,75) = gd(0,17);
    au(58,53)=gd(0,9);

    aus = odotstar(au); // \overline{A}_*

    // SYSTEM MATRIX A
    a = duallfrac(als,aus);
 
    // KLEENE STAR OF SYSTEM MATRIX A
    as=star(a);

return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
