#include "/home/brunsch/DAAD/angers/software/develop/dual_residuation/include/lminmaxgd.h"


#include <iostream>
#include <string.h>
#define LONGUEURMAX 2048
#define N 8

using namespace std;

int main(void)
{
try{
    int i,j;
    
    // include the system matrices (computationally expensive -- star matrices were computed once and then saved in the corresponding files)
    //    #include "daten/MatrixA_optimal.h";//smatrix al defined;
    //    #include "daten/als_optimal.h";//smatrix als; poly pals,qals; gd rals defined;
    //    #include "daten/aus_optimal.h"; //smatrix aus
    #include "daten/as_optimal.h";//smatrix as; poly pas,qas; gd ras defined;

    smatrix b(140,22), c(1,140), asb(140,22),casb(1,22),umin(22,1);

    // definition of input matrix B
    // INCUBATOR
    b(0,0)    = e;
    b(59,1)   = e;
    b(81,2)   = e;
    b(135,3)  = e;
    // ROBOT I
    b(10,4)   = e;
    b(27,5)   = e;
    b(53,6)   = e;
    b(75,7)   = e;
    b(91,8)   = e;
    b(105,9)  = e;
    b(117,10) = e;
    b(129,11) = e;
    // ROBOT II
    b(21,12)  = e;
    b(64,13)  = e;
    // CYBIWELL
    b(33,14)  = e;
    b(97,15)  = e;
    // PEAK CAROUSEL
    b(5,16)   = e;
    b(16,17)  = e;
    b(70,18)  = e;
    b(86,19)  = e;
    // SHAKER
    b(111,20) = e;
    // READER
    b(123,21) = e;

    // INCUBATOR
    c(0,139)  = e;

    asb = otimes(as,b);
    casb = otimes(c,asb);

    // fastest input, i.e., umin = e
    for(i=0;i<22;i++)
    {
        umin(i,0) = gd(0,0);
    }


    smatrix cas(1,140), hxu(140,22), gref(1,22), alsb(140,22);

    gref = casb;
    cas = otimes(c,as);
    hxu = lfrac(gref,cas);
    alsb = otimes(als,b);

    smatrix p0(22,22),p1(22,22),popt(22,22),popt_caus(22,22),popt_causpm(22,22),alsbp0(140,22),alsbpopt(140,22);
    
    // starting point for fix point algorithm
    p0 = lfrac(gref,casb);

    // fix point algorithm (up to 100 steps)
    for(i=0;i<100;i++)
    {
        alsbp0 = otimes(alsb,p0);
        p1 = lfrac(alsbp0,asb);
        if(p0==p1)
        {
            cout<<"Fixed point algorithm terminated after "<<i<<" steps.\n";
            popt = p0;
            popt_caus = prcaus(popt);
            popt_causpm = prcauspm(popt);
            alsbpopt = alsbp0;
            break;
        }
        if(i==99)
        {
            cout<<"Fixed point algorithm DID NOT terminate after 100 steps!!!.\n";
        }
        p0 = p1;
    }

    // TEST CONDITIONS ON POPT:
    smatrix cond1(140,22), cond2(140,22);
    cond1 = oplus(alsbpopt,hxu);
    if(hxu == cond1)
    {
        cout<<"\n1st condition on P_opt fulfilled!\n";
    }
    else
    {
        cout<<"\n1st condition on P_opt NOT fulfilled!!!\n";
    }
    cond2 = otimes(asb,popt);
    if(alsbpopt==cond2)
    {
        cout<<"2nd condition on P_opt fulfilled!\n";
    }
    else
    {
        cout<<"2nd condition on P_opt NOT fulfilled!!!\n";
    }


    // COMPUTE OPTIMAL FEEDBACK CONTROLLER:
    smatrix alsbpoptralsbpopt(140,140), fopt(22,140),fopt_caus(22,140), fopt_causpm(22,140);
    alsbpoptralsbpopt = rfrac(alsbpopt,alsbpopt);
    fopt = lfrac(alsbpoptralsbpopt,alsb);
    fopt_caus = prcaus(fopt);
    fopt_causpm = prcauspm(fopt);

    // TEST CONDITIONS ON FOPT:
    smatrix alsbfopt(140,140), alsbfopts(140,140), alsbfoptsalsbpopt(140,22),asalsbfoptsalsbpopt(140,22);
    alsbfopt = otimes(alsb,fopt);
    alsbfopts = star(alsbfopt);
    alsbfoptsalsbpopt = otimes(alsbfopts,alsbpopt);
    if(alsbfoptsalsbpopt == alsbpopt)
    {
        cout<<"\n1st condition on F_opt fulfilled!\n";
    }
    else
    {
        cout<<"\n1st condition on F_opt NOT fulfilled!\n";
    }
    asalsbfoptsalsbpopt = otimes(as,alsbfoptsalsbpopt);
    if(asalsbfoptsalsbpopt == alsbfoptsalsbpopt)
    {
        cout<<"2nd condition on F_opt fulfilled!\n";
    }
    else
    {
        cout<<"2nd condition on F_opt NOT fulfilled!\n";
    }


    smatrix x_jit(140,1),x_jit_caus(140,1), u_jit(22,1), u_jit_caus(22,1);
    x_jit = otimes(alsbfoptsalsbpopt,umin);
    x_jit_caus = prcaus(x_jit);
    u_jit =otimes(fopt,x_jit);
    u_jit = oplus(u_jit,umin);
    u_jit_caus = prcaus(u_jit);

return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
