#include "/home/brunsch/DAAD/angers/software/develop/dual_residuation/include/lminmaxgd.h"


using namespace std;

int main(void)
{
try{
    smatrix al(14,14),als(14,14),au(14,14),aus(14,14),a(14,14),as(14,14);
    int i,j;

    //act1
    al(1,0)=gd(0,10);
    al(2,1)=gd(0,3);

    //act2
    al(4,3)=gd(0,1);
    al(5,4)=gd(0,10);
    al(6,5)=gd(0,1);

    //act3
    al(8,7)=gd(0,1);
    al(9,8)=gd(0,10);
    al(10,9)=gd(0,5);

    //act4
    al(12,11)=gd(0,2);
    al(13,12)=gd(0,15);

    //transfer
    al(1,4)=gd(0,0);
    al(4,1)=gd(0,0);
    al(8,5)=gd(0,0);
    al(5,8)=gd(0,0);
    al(9,12)=gd(0,0);
    al(12,9)=gd(0,0);

    //schedule
    al(0,13)=gd(2,0);
    al(3,6)=gd(1,0);
    al(7,10)=gd(1,0);

    // compute Kleene star of $\underline{A}$
    als=star(al);

    // initialize matrix $\overline{A}$
    for(i=0;i<14;i++)
    {
        for(j=0;j<14;j++)
        {
            au(i,j)=Top;
        }
    }

    // constraints of the system
    au(5,4)=gd(0,12);
    au(2,11)=gd(1,0);

    // compute dual Kleene star of $\overline{A}
    aus = odotstar(au);

    // compute system matrix $\underline{overline{A}}$ and its Kleene star
    a = duallfrac(als,aus);
    as = star(a);

    smatrix b(14,4), c(1,14), asb(14,4),casb(1,4),umin(4,1),ymax(1,1),ujit(4,1),x(14,1);

    // INPUT MATRIX B
    b(0,0)=gd(0,0);
    b(3,1)=gd(0,0);
    b(7,2)=gd(0,0);
    b(11,3)=gd(0,0);

    // OUTPUT MATRIX C
    c(0,13)=gd(0,0);

    asb=otimes(as,b);
    casb=otimes(c,asb);

    // minimal input, i.e., u=e;
    umin(0,0)=gd(0,0);
    umin(1,0)=gd(0,0);
    umin(2,0)=gd(0,0);
    umin(3,0)=gd(0,0);

    ymax = otimes(casb,umin);
    ymax = prcaus(ymax);
    ujit=lfrac(ymax,casb);
    ujit=prcaus(ujit);
    x=otimes(asb,ujit);
    x=prcaus(x);

    smatrix cas(1,14), hxu(14,4), gref(1,4), alsb(14,4),hxulalsb(4,4), hxux(14,4);

    gref = casb;
    cas = otimes(c,as);
    hxu = lfrac(gref,cas);
    alsb = otimes(als,b);
    hxulalsb = lfrac(hxu,alsb);
    hxux=otimes(alsb,hxulalsb);

    smatrix p0(4,4),p1(4,4),alsbp0(14,4), phelp(4,4), prcausp1(4,4);

    // starting value for fix point algorithm
    p0 = lfrac(gref,casb);

    int k,l;
    k=0;
    l=0;
    // fix point algorithm
    while((l==0) || (k<100))
    {
        if(k==0)
        {
            p1 = p0;
        }
        if(k>0)
        {
            p0 = p1;
        }
        alsbp0 = otimes(alsb,p0);
        phelp = lfrac(alsbp0,asb);
        prcausp1 = prcauspm(p1);
        p1 = inf(phelp,p1);
        p1 = inf(p1,prcausp1);
        p1 = inf(p1,hxulalsb);
        if(p0==p1)
        {
            cout<<"\nOptimal Prefilter found in "<<k<<" steps!\n\nPopt = \n"<<p0;
            l = 1;
            k = 100;
        }
        k = k+1;
    }


    //test conditions on p_opt
    smatrix cond1(14,4),cond2(14,4);
    cond1 = oplus(alsbp0,hxu);
    if(hxu==cond1)
    {
        cout<<"\n1st condition on P_opt fulfilled!\n";
    }
    cond2 = otimes(asb,p0);
    if(alsbp0==cond2)
    {
        cout<<"2nd condition on P_opt fulfilled!\n";
    }

    //feedback
    smatrix fopt(4,14), foptcaus(4,4), alsbpoptralsbpopt(4,4), fraw(4,14);
    alsbpoptralsbpopt=rfrac(alsbp0,alsbp0);
    fopt = lfrac(alsbpoptralsbpopt,alsb);
    fraw = fopt;
    foptcaus=prcauspm(fopt);
    fopt = foptcaus;

    //conditions on f_opt
    smatrix bfopt(14,14),alpbfopt(14,14),alpbfopts(14,14),alpbfoptsb(14,4),alpbfoptsbpopt(14,4),asalpbfoptsbpopt(14,4);
    bfopt = otimes(b,fopt);
    alpbfopt = oplus(al,bfopt);

    smatrix alsbfopt(14,14), alsbfopts(14,14), alsbfoptsals(14,14), alsbfoptsalsb(14,4), alsbfoptsalsbpopt(14,4), asalsbfoptsalsbpopt(14,4);
    alsbfopt = otimes(alsb,fopt);
    alsbfopts = star(alsbfopt);
    alsbfoptsals = otimes(alsbfopts,als);
    alsbfoptsalsb = otimes(alsbfoptsals,b);
    alsbfoptsalsbpopt=otimes(alsbfoptsalsb,p0);
    asalsbfoptsalsbpopt=otimes(as,alsbfoptsalsbpopt);

    if(alsbfoptsalsbpopt==alsbp0)
    {
        cout<<"\n1st condition on F_opt fulfilled.";
    }
    else
    {
        cout<<"\n1st condition on F_opt NOT fulfilled!!!";
    }
    if(alsbfoptsalsbpopt == asalsbfoptsalsbpopt)
    {
        cout<<"\n2nd condition on F_opt fulfilled.";
    }
    else
    {
        cout<<"\n2nd condition on F_opt NOT fulfilled!!!";
    }

return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
