#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Observer Synthesis, Example taken from paper
[1] arXiv:0901.2915v1 (authors DiLoreto, Gaubert Katz, Loiseau
Synthesis down thanks to results in
[2] "Observer Design for max,+ linear systems
(IEEE TAC, 2010, Hardouin, Maia, Cottenceau, Lhommeau)



// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"


/**************************************************************************************/
/* this example present the main function of the library
   and the different manner to declare monomial polynom serie and matrix */
/**************************************************************************************/
using namespace std;
#define N 6
int main(void)
{
try{
  poly poly1,poly2;
  gd r1;
  //smatrix a(7,7),b(7,3),c(1,7), as(7,7);
    smatrix a(N,N),b(N,3),c(1,N), as(N,N);
    smatrix p1(1,1),p2(1,1),p3(1,1),p4(1,1);
smatrix H(4,1);
    p1(0,0).init(poly1.init(0,0)(1,4),poly2.init(2,15),r1.init(1,9));
    p2(0,0).init(poly1.init(1,9),poly2.init(2,15),r1.init(1,9));
    p3=rfrac(p1,p2);

    p4=otimes(p2,p3);
H(0,0).init(poly1.init(0,0)(1,4),poly2.init(2,15),r1.init(1,9));
H(1,0).init(poly1.init(0,3)(1,7),poly2.init(2,18),r1.init(1,9));
H(2,0).init(epsilon,poly2.init(-1,4)(0,10),r1.init(1,9));
H(3,0).init(epsilon,poly2.init(-1,8)(0,14),r1.init(1,9));
smatrix fed;
fed=rfrac(H,H);
fed=lfrac(fed,H);
//fed =prcaus(fed);
//cout<<" fed "<<fed(0,3);
// 15:00 le 23 mars
a(0,1).init(epsilon,poly1.init(1,0),e);
a(1,0).init(epsilon,poly1.init(0,2),e);
a(2,3).init(epsilon,poly1.init(1,0),e);
a(3,2).init(epsilon,poly1.init(0,5),e);
a(4,1).init(epsilon,poly1.init(0,1),e);
a(4,3).init(epsilon,poly1.init(0,3),e);
a(4,5).init(epsilon,poly1.init(3,0),e);
a(5,4).init(epsilon,poly1.init(0,2),e);


b(0,0)=e;
//b(7,0)=e;
b(2,1)=e;
b(4,2)=e;

c(0,3)=e;

as = star(a);
cout<<"as"<<as;


return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accès à un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carré uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}

