
#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif

#include <time.h>
#include <stdio.h>
// XavierTestCACABABStar.cpp :
// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
//
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

int main(void)
{
try{

// System Matrices
 smatrix a(7,7), Y0, b(7,2), c(2,7), Y0b, cY0, h;
 smatrix abis(7,7);
 int i,j;
 for (i=0;i<7;i++)
 abis(i,i)=e;


a(0,0) = gd(3,0);
a(0,0)=epsilon;
a(0,1) = gd(3,2);
a(0,1)=epsilon;
a(0,2) = gd(1,1);

a(0,3) = gd(2,0);
a(0,4) = gd(1,2);
a(0,5) = gd(2,0);
a(0,5) = epsilon;
a(0,6) = gd(2,2);
a(0,6) = epsilon;

a(1,0) = gd(3,2);
a(1,0)=epsilon;
a(1,1) = gd(3,1);
a(1,1)=epsilon;
a(1,2) = gd(3,2);
a(1,2)=epsilon;
a(1,3) = gd(3,2);
a(1,3)=epsilon;
a(1,4) = gd(2,0);
a(1,4)=epsilon;
a(1,5) = gd(1,2);
a(1,5)=epsilon;
a(1,6) = gd(1,0);
a(1,6)=epsilon;

a(2,0) = gd(1,2);

a(2,1) = gd(3,1);
a(2,1)=epsilon;
a(2,2) = gd(3,0);
a(2,2)=epsilon;
a(2,3) = gd(2,2);
a(2,3)=epsilon;
a(2,4) = gd(2,2);
a(2,4)=epsilon;
a(2,5) = gd(3,1);
a(2,5)=epsilon;
a(2,6) = gd(1,1);
a(2,6)=epsilon;

a(3,0) = gd(3,0);
a(3,0)=epsilon;
a(3,1) = gd(1,2);
a(3,1)=epsilon;
a(3,2) = gd(1,2);

a(3,3) = gd(2,1);
a(3,3)=epsilon;
a(3,4) = gd(2,1);
a(3,4)=epsilon;
a(3,5) = gd(2,0);
a(3,5)=epsilon;
a(3,6) = gd(1,0);
a(3,6)=epsilon;

a(4,0) = gd(2,2);
a(4,0)=epsilon;
a(4,1) = gd(2,1);
a(4,1)=epsilon;
a(4,2) = gd(1,2);

a(4,3) = gd(1,2);

a(4,4) = gd(3,2);
a(4,4)=epsilon;
a(4,5) = gd(3,0);
a(4,5)=epsilon;
a(4,6) = gd(2,0);
a(4,6)=epsilon;

a(5,0) = gd(3,2);
a(5,0)=epsilon;
a(5,1) = gd(2,2);
a(5,1)=epsilon;
a(5,2) = gd(3,0);
a(5,2)=epsilon;
a(5,3) = gd(1,1);
a(5,3)=epsilon;
a(5,4) = gd(1,0);
a(5,4)=epsilon;
a(5,5) = gd(2,1);
a(5,5)=epsilon;
a(5,6) = gd(3,2);
a(5,6)=epsilon;

a(6,0) = gd(1,0);
a(6,0)=epsilon;
a(6,1) = gd(3,0);
a(6,1)=epsilon;
a(6,2) = gd(3,1);
a(6,2)=epsilon;
a(6,3) = gd(2,2);
a(6,3)=epsilon;
a(6,4) = gd(3,0);
a(6,4)=epsilon;
a(6,5) = gd(1,2);
a(6,5)=epsilon;
a(6,6) = gd(3,2);
a(6,6)=epsilon;

b(0,0) = gd(2,2);
b(1,1) = gd(0,2);
b(2,1) = gd(0,1);
b(6,0) = gd(2,1);

c(0,0) = gd(1,0);
c(1,2) = e;

// Calculation of the transfer function matrix

Y0 = star(a);

if (otimes(Y0,Y0)==Y0) cout<<"Star OK\n\n";
else cout<<"Star Wrong \n"<<endl;
Y0b = otimes(Y0,b);
cY0 = otimes(c,Y0);
h = otimes(c,Y0b);

cout <<" h"<<h<<endl;


// Calculation of the first iteration
smatrix Y1(7,7), X1(7,7), temp(7,2), Comp(7,7) ;
smatrix temp1=lfrac(h,cY0);
if (otimes(Y0,temp1)==temp1) cout<<"OK";
else cout<<"Wrong";


/////First step calculation of X1

temp = lfrac(h,cY0);
X1 = rfrac(temp,Y0b);



///// Second step: calculation of Y1
Y1 = rfrac(X1,X1);

// Comparison of Y0 and Y1
Comp = oplus(Y0,Y1);

if(Comp == Y1){cout<<"Y1 greater than Y0: OK";}
else if (Comp == Y0){cout<<"Y0 strictly greater than Y1: WRONG";}
else {cout<<" Y0 and Y1 are not comparable: WRONG ";}


}
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accès à un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carré uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
