
#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
#endif

/**************************************************************************************/
/* this example present the main function of the library
   and the different manner to declare monomial polynom serie and matrix */
/**************************************************************************************/
using namespace std;
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"
int main(void)
{
try{

// System Matrices
 smatrix a(3,3), Y0(3,3), b(3,1), c(1,3), Y0b(3,1), cY0(1,3), h(1,1);

a(0,0) = gd(3,2);
a(0,1) = gd(2,2);
a(0,2) = gd(1,1);

a(1,0) = gd(3,2);
a(1,1) = gd(1,0);
a(1,2) = gd(3,2);

a(2,0) = gd(1,0);
a(2,1) = gd(1,2);
a(2,2) = gd(2,0);


b(0,0) = gd(1,2);

c(0,0) = gd(2,2);
c(0,2) = gd(2,0);

// Calculation of the transfer function matrix
Y0 = star(a);
Y0b = otimes(Y0,b);
cY0 = otimes(c,Y0);
h = otimes(c,Y0b);

// Calculation of the first iteration
smatrix X1(3,3), Y1(3,3), temp(3,1), h1(1,1);

/////First step calculation of X1
temp = lfrac(h,cY0);
X1 = rfrac(temp,Y0b);

///// Second step: calculation of Y1
Y1 = rfrac(X1,X1);

temp = otimes(Y1,b);
h1 = otimes(c,temp);

if(h1 == h){cout<<" Y1 et Y0 leads to the same transfer function ";}
else {cout<<" Y1 et Y0 leads to two different transfer functions: WRONG ";}

 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accès à un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carré uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
