#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : transport system paper ZeCury
Maia C.A., Hardouin L., Cury J.E.R.
"Some results on the feedback control of max-plus linear systems under state constrains",
Conference on Decision and Control, CDC 2013, Firenze.
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{
int i,j;
	smatrix A0(3,3);	// matrice d'tat

A0(1,0)=gd(0,2);
A0(1,2)=gd(0,3);
A0(2,0)=gd(0,4);

smatrix A;

A=star(A0);
cout<<"A*"<<A<<endl;

smatrix C(3,3), D(3,3);
C(0,0)=gd(0,2);C(0,1)=gd(0,5);
C(1,0)=gd(0,2);C(1,1)=gd(0,7);C(1,2)=gd(0,7);
C(2,0)=gd(0,7);C(2,1)=gd(0,9);C(2,2)=gd(0,1);


D(0,0)=gd(0,1);D(0,1)=gd(0,4);D(0,2)=gd(0,4);
D(1,0)=gd(0,6);D(1,1)=gd(0,3);D(1,2)=gd(0,1);
D(2,0)=gd(0,2);D(2,1)=gd(0,5);D(2,2)=gd(0,8);

smatrix b(3,1);

b(0,0)=gd(0,15);b(1,0)=gd(0,15);b(2,0)=gd(0,15);

smatrix CX,DX,DCX, CDX, X;

for(i=0;i<3;i++)
{
    CX=otimes(C,b);
    cout<<"CX"<<CX<<endl;

    DX=otimes(D,b);
    cout<<"DX"<<DX<<endl;
    DCX=lfrac(CX,D);
    cout<<"DCX"<<DCX<<endl;
    CDX=lfrac(DX,C);
    cout<<"CDX"<<CDX<<endl;
    X=inf(b,CDX);
    X=inf(X,DCX);
    cout<<"X"<<X<<endl;
    b=X;
}




	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
