#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>

/////////////////////////////////////////////////////////////////////
/* Example : Discrete Event Systems in Dioid Framework : Control Theory
 Laurent Hardouin, Olivier Boutin, Bertrand Cottenceau, Thomas Brunsch, Joerg Raisch
 Springer, DISC Book
This program compute :
1. the optimal control when a reference output is a priori known
2. the optimal input filtering when the reference output is unknown
3. the optimal feedback
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"


using namespace std;
using namespace mmgd;

int main(void)
{
try{
int N=4;
int WN=2;
smatrix A0(N,N);
smatrix A1(N,N);
smatrix B0(N,N);
smatrix A0s, A1s,B0s;
smatrix S,Sstar;
smatrix WA0(WN,WN);
smatrix WA1(WN,WN);
smatrix WB1(WN,WN);
smatrix WA0s, WA1s,WB1s;
smatrix WS,WSstar;

A0(0,1)=gd(0,2);
A0(2,0)=gd(0,0);
A0(2,3)=gd(0,1);
cout<<" A0 "<< A0<<endl;
A1(1,0)=gd(1,0);
A1(3,2)=gd(1,0);
cout<<" A1 "<< A1<<endl;
B0(1,0)=gd(0,-2);
B0(3,2)=gd(0,-1);
cout<<" B0 "<< B0<<endl;
A0s=star(A0);
A1s=star(A1);
B0s=star(B0);
cout<<" A0s "<< A0s<<endl;
cout<<" A1s "<< A1s<<endl;
cout<<" B0s "<< B0s<<endl;
S=oplus(A0,A1);
S=oplus(S,B0);
Sstar=star(S);
cout<<"****************"<<endl;
WA0(1,0)=gd(0,0);
cout<<" WA0 "<< WA0<<endl;
WA1(0,0)=gd(1,2);
WA1(1,1)=gd(1,1);
cout<<" WA1 "<< WA1<<endl;
WB1(0,0)=gd(1,2);
WB1(1,1)=gd(1,1);
cout<<" WB1 "<< WB1<<endl;
WA0s=star(WA0);
WA1s=star(WA1);
WB1s=star(WB1);
cout<<" WA0s "<< WA0s<<endl;
cout<<" WA1s "<< WA1s<<endl;
cout<<" WB1s "<< WB1s<<endl;
WS=oplus(WA0,WA1);
WS=oplus(WS,WB1);
cout<<" WS "<< WS<<endl;

WSstar=star(WS);
cout<<" WSstar "<< WSstar<<endl;


return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
