#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>


//serie odot(serie &,serie &);
/////////////////////////////////////////////////////////////////////
/* Example : Duality and interval analysis over idempotent semiring
Thomas Brunsch, Laurent Hardouin, Carlos Andrey Maia, Joerg Raisch
Submited to : Linear Algebra And its Applications

The goal of this programm is to compute with interval analysis the
projection of a degenerated interval X=\underline{X}=\overline{X}
in the solution set of the equation
A\otimes X <= X <= B \odot X

where A and B are matrices of interval whith bounds in Zmax of gamma
Each bound of entries of B are assumed to be monomial

*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{
    int N=2;
    smatrix A(N,N);
    smatrix B(N,1);
    smatrix R(N,N);
    smatrix C(2,N);
    smatrix As(N,N);
    smatrix CA;
    smatrix AB;
    smatrix CAB;
    smatrix AR;
    smatrix CAR;
    smatrix TestObs;




  A(0,1)=gd(0,6);

 /* here I define a B matrix */

  B(0,0)=gd(0,2);
  B(1,0)=gd(0,4);

  C(0,0)=gd(0,2);
  C(1,1)=gd(0,4);

  R(0,0)=gd(0,0);
  R(1,1)=gd(0,0);

 As=star(A);
 cout <<"As = "<<As<<endl;
  AB=otimes(As,B);
  cout <<"AB = "<<AB<<endl;
  CA=otimes(C,As);
  CAB=otimes(CA,AB);
  cout <<"CAB = "<<CAB<<endl;

  AR=otimes(As,R);
  cout <<"AR = "<<AR<<endl;
  CAR=otimes(CA,AR);
  cout <<"CAR = "<<CAR<<endl;

 TestObs=rfrac(AB,CAB);
 TestObs=otimes(TestObs,CAB);
 cout <<"(AB/CAB)CAB = "<<TestObs<<endl;
 if (TestObs==AB)
 {
     cout<<" Sytem is observable since (AB/CAB)CAB == AB (item 3. Theorem 7 is true)"<<endl;
 }

 smatrix L1=rfrac(AB,CAB);
 smatrix  L2=rfrac(AR,CAR);
 smatrix Lopt=inf(L1,L2);

  cout<<" Lopt "<<Lopt<<"\n";

 smatrix LCAB=otimes(Lopt,CAB);
 cout<<" LCAB "<< LCAB <<endl;

 smatrix LCAR=otimes(Lopt,CAR);
 cout<<" LCAR "<< LCAR <<endl;
 if((LCAB==AB) && (LCAR==AR))
 {
     cout<<"According to Theorem 8 the estimated state is equal to the real state"<<endl;
 }

    return(0);
}


 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}


