#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>

/////////////////////////////////////////////////////////////////////
/* Example : Discrete Event Systems in Dioid Framework : Control Theory
 Laurent Hardouin, Olivier Boutin, Bertrand Cottenceau, Thomas Brunsch, Joerg Raisch
 Springer, DISC Book
This program compute :
1. the optimal control when a reference output is a priori known
2. the optimal input filtering when the reference output is unknown
3. the optimal feedback
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"


using namespace std;
using namespace mmgd;

int main(void)
{
try{
int N=2;

smatrix A0(N,N);
smatrix B0(N,1);
smatrix C0(1,N);
smatrix AB;
smatrix CAB;
smatrix As;
A0(0,1)=gd(1,5);
A0(1,0)=gd(0,2);
B0(0,0)=gd(0,6);
C0(0,1)=gd(0,0);

cout<<" A0 "<< A0<<endl;

cout<<" B0 "<< B0<<endl;
As=star(A0);
cout<<" As "<< As<<endl;
AB=otimes(As,B0);

cout<<" AB "<< AB<<endl;
CAB=otimes(C0,AB);
cout<<" CAB "<< CAB<<endl;


double x=log(5);
printf("%f \n",x);

return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
