#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Observer Synthesis, Example taken from paper
[1] arXiv:0901.2915v1 (authors DiLoreto, Gaubert Katz, Loiseau
Synthesis down thanks to results in
[2] "Observer Design for max,+ linear systems
(IEEE TAC, 2010, Hardouin, Maia, Cottenceau, Lhommeau)

The goal of this programm is to compute with interval analysis the
observer matrix L =[L_inf L_sup]
and to compare with the one given in [2]

// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A0_inf(4,4);	// matrice d'tat
	smatrix A0_sup(4,4);	// matrice d'tat
    smatrix A_inf(4,4);	// matrice d'tat
    smatrix A_sup(4,4);	// matrice d'tat
    smatrix B_inf(4,1);	// matrice d'tat
    smatrix B_sup(4,1);	// matrice d'tat
    smatrix C_inf(1,4);	// matrice d'tat
    smatrix C_sup(1,4);	// matrice d'tat


	smatrix R(1,1);
    smatrix U_inf,U_sup;

	int i,j;



	A_inf(0,0)=gd(1,300);//(1,3)
	A_inf(1,1)=gd(1,100);//(1,1)
	A_inf(2,2)=gd(1,200);//(1,2)
	A_inf(3,3)=gd(1,100);//(1,1)

    A_sup(0,0)=gd(1,30);//(1,0.3)
	A_sup(1,1)=gd(1,20);//(1,0.2)
	A_sup(2,2)=gd(1,10);//(1,0.1)
	A_sup(3,3)=gd(1,25);//(1,0.25)


	A0_inf(1,0)=gd(0,300+500);//(0,1)
	A0_inf(2,1)=gd(0,100+400);//(0,2)
	A0_inf(3,2)=gd(0,200+500);//(0,1)

	A0_sup(1,0)=gd(0,30);//(1,0.2)
	A0_sup(2,0)=gd(0,20);//(1,0.1)
	A0_sup(3,0)=gd(0,10);//(1,0.25)


	smatrix A0star_inf=star(A0_inf);
	smatrix A0star_sup=star(A0_sup);
	smatrix Ad=otimes(A0star_inf,A_inf);
	smatrix Ads=otimes(A0star_sup,A_sup);

	C_inf(0,3)=gd(0,100+100);
	C_sup(0,3)=gd(0,25);

	B_inf(0,0)=gd(0,500);//(1,3)
	smatrix Bd=otimes(A0star_inf,B_inf);


    cout<<" Ad = \n"<<Ad<<endl;
    cout<<" Bd = \n"<<Bd<<endl;
    return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
