#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>


//serie odot(serie &,serie &);
/////////////////////////////////////////////////////////////////////
/* Example : Duality and interval analysis over idempotent semiring
Thomas Brunsch, Laurent Hardouin, Carlos Andrey Maia, Joerg Raisch
Submited to : Linear Algebra And its Applications

The goal of this programm is to compute with interval analysis the
projection of a degenerated interval X=\underline{X}=\overline{X}
in the solution set of the equation
A\otimes X <= X <= B \odot X

where A and B are matrices of interval whith bounds in Zmax of gamma
Each bound of entries of B are assumed to be monomial

*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{
    int N=4;
   smatrix B(N,N);
   smatrix Bn(N,N);
   smatrix BDualStar(N,N);
    smatrix DualIdentity(N,N);
    smatrix Identity(N,N);

    int i,j;
  for(i=0;i<DualIdentity.getrow();i++)
  {
      for(j=0;j<DualIdentity.getcol();j++)
      {
          DualIdentity(i,j)=gd(_infinity,infinity);
          B(i,j)=gd(_infinity,infinity); // B is initialized to Top

          if (i==j) {
              DualIdentity(i,j)=e;
              Identity(i,j)=e;
          }
      }
  }
  poly pol;

B(0,1)=gd(3,15); // 15\gamma^3
B(0,2)=gd(0,7); // 7 \gamma^0
B(2,0)=gd(0,3); // 3 \gamma^0
B(2,1)=gd(4,8);  // 8 \gamma^4
B(3,0)=gd(1,6);  // 6 \gamma^1
B(3,1)=gd(5,4);  // 4 \gamma^5

  Bn=B;

  BDualStar=DualIdentity;
  smatrix Temp=inf(Bn,BDualStar);
   i=1;
   cout<<"B^"<<i<<" =\n"<<Bn<<endl;
  while(!(BDualStar==Temp))
         {
             BDualStar=Temp;
             Bn=odot(Bn,B);
             i++;
             Temp=inf(Temp,Bn);
             cout<<"B^"<<i<<" =\n"<<Bn<<endl;
         }

cout<<"BDualStar\n"<<BDualStar<<endl;



    return(0);
}


 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}


