#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>




/////////////////////////////////////////////////////////////////////
/* Example :

*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

int main()
{
try
{


   smatrix   AL(3,3); // state matrix 6x6
   smatrix   BL(3,1); // input matrix 6x2, 2 inputs
   smatrix   CL(3,1);
   smatrix   AU(3,3); // state matrix 6x6
   smatrix   BU(3,1); // input matrix 6x2, 2 inputs
   smatrix   CU(3,1);

    AL(0,0)=gd(0,7);
    AL(0,1)=gd(0,4);
    AL(0,2)=gd(0,2);
    AL(1,0)=gd(0,8);
    AL(1,1)=gd(0,7);
    AL(1,2)=gd(0,1);
    AL(2,0)=gd(0,7);
    AL(2,1)=gd(0,1);
    AL(2,2)=gd(0,10);

    AU(0,0)=gd(0,8);
    AU(0,1)=gd(0,5);
    AU(0,2)=gd(0,3);
    AU(1,0)=gd(0,8);
    AU(1,1)=gd(0,9);
    AU(1,2)=gd(0,3);
    AU(2,0)=gd(0,9);
    AU(2,1)=gd(0,2);
    AU(2,2)=gd(0,13);

    BL(0,0)=gd(0,12);
    BL(1,0)=gd(0,14);
    BL(2,0)=gd(0,16);

    BU(0,0)=gd(0,13);
    BU(1,0)=gd(0,14);
    BU(2,0)=gd(0,18);

    CL=lfrac(BL,AL);
    cout<<"CL "<<CL<<endl;
    CU=lfrac(BU,AU);
    CL=inf(CL,CU);

    cout<<"CL "<<CL<<endl;
    cout<<"CU "<<CU<<endl;

   smatrix ACL, ACU;
   ACL=otimes(AL,CL);
   ACU=otimes(AU,CU);
    cout<<"ACL "<<ACL<<endl;
    cout<<"ACU "<<ACU<<endl;




	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
