#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Observer Synthesis, Example taken from paper
[1] arXiv:0901.2915v1 (authors DiLoreto, Gaubert Katz, Loiseau
Synthesis down thanks to results in
[2] "Observer Design for max,+ linear systems
(IEEE TAC, 2010, Hardouin, Maia, Cottenceau, Lhommeau)



// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"


/**************************************************************************************/
/* this example present the main function of the library
   and the different manner to declare monomial polynom serie and matrix */
/**************************************************************************************/
using namespace std;
#define N 8
int main(void)
{
try{
  poly poly1,poly2;
  gd r1;
  //smatrix a(7,7),b(7,3),c(1,7), as(7,7);
    smatrix a(N,N),b(N,3),c(1,N), as(N,N);
    smatrix p1(1,1),p2(1,1),p3(1,1),p4(1,1);
smatrix H(4,1);


    p1(0,0).init(epsilon,poly1.init(0,0)(1,2)(2,5)(3,10)(4,15)(5,20)(6,45)(7,47)(8,50)(9,55)(10,65)(11,73)
    (12,76)(13,85)(14,90)(15,108)(16,112)(17,118)(18,125)(19,130)(20,136)(21,infinity),e);
    p2(0,0).init(epsilon,poly1.init(0,0)(1,10)(2,20)(3,30)(4,40)(5,45)(6,50)(7,55)(8,60)(9,65)(10,73)(11,76)
    (12,85)(13,90)(14,109)(15,112)(16,118)(17,125)(18,133)(19,140)(20,144)(21,infinity),e);

    p3=rfrac(p2,p1);
    cout<<"optimal control "<<p3<<endl;
    p3=otimes(p1,p3);
cout<<"optimal output "<<p3<<endl;
int i;
int J=0;
for (i=0;i<p3(0,0).getp().getn()-1;i++)
{ //printf("%d\n",p3(0,0).getp().getpol(i).getd());
printf("%d\n",p3(0,0).getp().getpol(i+1).getd()-p3(0,0).getp().getpol(i).getd());

}

return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accès à un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carré uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}

