#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Observer basesd controller and comparison with output feedbnack
 Example taken from paper
[2] "Observer-based Controllers for (Max-Plus)-Linear Systems"
Laurent Hardouin, Ying Shang, Carlos Andrey Maia, Bertrand Cottenceau
(IEEE TAC, 2010)
// see also animation on http://perso-laris.univ-angers.fr/~hardouin/Observer.html
// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files, it is the most friendly to do
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"
#include "time.h"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A(6,6);	// matrice d'tat
smatrix M(6,6);
smatrix N(6,6);
smatrix Id(6,6);
	smatrix Lopt,L1,L2,Loptcausal;
	int i,j;

	smatrix CA,AB,CAB,AR,CAR;
	smatrix Gref;
	smatrix Popt, Fopt,Kopt;

srand(time(NULL));
 A(0,1)=gd(1,0);
 A(1,0)=gd(0,2);
 A(2,3)=gd(1,0);
 A(3,2)=gd(0,5);
 A(4,1)=gd(0,1);
 A(4,3)=gd(0,3);
 A(4,5)=gd(3,0);
 A(5,4)=gd(0,2);









	smatrix C(1,6);	// output matrix only coefficient on diagonl equal to e or epsilon

    C(0,5)=gd(0,0);

    smatrix B(6,2);	// matrix of inputs, epsilon everywhere
	B(0,0)=gd(0,1);
	B(2,1)=gd(0,2);

	smatrix R(6,6); // matrix connecting the uncontrollable input and the state
	R(0,0)=gd(0,0);
	R(1,1)=gd(0,0);
    R(2,2)=gd(0,0);
    R(3,3)=gd(0,0);
	R(4,4)=gd(0,0);
    R(5,5)=gd(0,0);
	smatrix As=star(A);
	CA=otimes(C,As);  // CA*

    AB=otimes(As,B);

    CAB=otimes(C,AB); // CA*B, the input output transfer matrix

cout<<" CAB"<<CAB<<endl;
    AR=otimes(As,R);

cout<<" AB"<<AB<<endl;
    CAR=otimes(C,AR); // CA*R, the disturbance output transfer matrix


//cout<<" CAR"<<CAR<<endl;





	L1=rfrac(AB,CAB);
	L2=rfrac(AR,CAR);
	Lopt=inf(L1,L2); // the uncausal observer

cout<<"Lopt noncausal : " <<Lopt<<endl;

    smatrix LoptCAB=otimes(Lopt,CAB);

cout<<"LoptCAB : " <<LoptCAB<<endl;

cout<<" AB"<<AB<<endl;
	Loptcausal=prcaus(Lopt); // the causal projection of the oberver matrix
    Lopt=Loptcausal;


cout<<"Lopt causal : " <<Loptcausal<<endl;

    smatrix LoptCABc=otimes(Lopt,CAB);

cout<<"LoptCAB : " <<LoptCABc<<endl;

// Below we check the Corallary 2


smatrix Yu;
Yu=otimes(Loptcausal,C);
Yu=oplus(A,Yu);
Yu=star(Yu);
Yu=otimes(C,Yu);
Yu=otimes(Yu,B);

smatrix Yw;
Yw=otimes(Loptcausal,C);
Yw=oplus(A,Yw);
Yw=star(Yw);
Yw=otimes(C,Yw);
Yw=otimes(Yw,Loptcausal);
Yw=otimes(Yw,CAR);

if (Yu==Yw)
{

cout<<" Corollary 2 is satified, the estimated output and the real output are equal "<<endl;
cout<<"Yu : " <<Yu<<endl;
cout<<"Yw : " <<Yw<<endl;
}

smatrix Aref(6,6), Bref, Cref;
smatrix Asref, CAref;
Cref=C;
Bref=B;
//Aref=A;
for (i=0;i<6;i++)
{
    Aref(i,i)=gd(1,5);
}
getchar();

Aref=oplus(Aref,A);
Asref=star(Aref);
//Asref=star(Aref);
cout<<" Asref "<<Asref<<endl;
CAref=otimes(Cref,Asref);
Gref=otimes(CAref,Bref);
 // reference model is chosen equal to the system, we want to keep the input ouptu performance and delaying as much as possible the input
cout<<" Gref "<<Gref<<endl;
getchar();

Popt=lfrac(Gref,CAB); // the prefilter

cout<<" Popt non  causal  "<<Popt<<endl;

smatrix Popt_causal=prcaus(Popt);

cout<<" Popt  causal  "<<Popt_causal<<endl;

Kopt=otimes(AB,Popt);
Kopt=rfrac(Popt,Kopt);
Kopt=lfrac(Kopt,Popt);
smatrix Kopt1;
Kopt1=otimes(AB,Popt_causal);
Kopt1=rfrac(Popt_causal,Kopt1);
Kopt1=lfrac(Kopt1,Popt_causal);

cout<<" Kopt non causal computed with non Causal Popt"<<Kopt<<endl; // the state feedback controller
cout<<" Kopt1 non causal computed with  Causal Popt"<<Kopt1<<endl; // the state feedback controller
if (Kopt==Kopt1)
{
    cout<<"No problem Kpot==Kopt1"<<endl;
}
else
{
    cout<<"to check "<<endl;
}
Fopt=rfrac(Kopt,C); // the ouput feedback controller

cout<<" Fopt non causal "<<Fopt<<endl;

// causal projection
Kopt=prcaus(Kopt);

Fopt=prcaus(Fopt);

Kopt1=prcaus(Kopt1);
cout<<" Fopt "<<Fopt<<endl;

cout<<" Kopt causal from non causal Popt"<<Kopt<<endl;
cout<<" Kopt1 causal from causal Popt"<<Kopt1<<endl;
if (Kopt==Kopt1)
{
    cout<<"No problem Kpotcausal==Kopt1causal"<<endl;
}
else
{
    cout<<"to check bis "<<endl;
}

// From now I try to enlighten that the strategy with oberverbasedcontrol is better than
// the feedback, I need your help Ying... :)
smatrix FoptC;
FoptC=otimes(Fopt,C);


// Below it appears that the observer based controller yields a greater control
// See Proposition 8
smatrix Xu,Xw;

Xu=otimes(Lopt,C);
Xu=oplus(A,Xu);
Xu=star(Xu);
Xu=otimes(Xu,B);
Xu=otimes(Kopt,Xu); // the transfer Kopt(A+LoptC)*B

Xw=otimes(Lopt,C);
Xw=oplus(A,Xw);
Xw=star(Xw);
Xw=otimes(Xw,Lopt);
Xw=otimes(Xw,CAR);
Xw=otimes(Kopt,Xw); // the transfer Kopt((A+LoptC)*)(LoptCA*)R

smatrix FCAB, FCAR;

FCAB=otimes(Fopt,CAB);
FCAR=otimes(Fopt,CAR);
smatrix KoptLopt;
if(!(FCAB==Xu) || !(FCAR==Xw))
{
cout<<" FCAB " <<FCAB<<endl;
cout<<" Xu "<<Xu<<endl;
cout<<" FCAR " <<FCAR<<endl;
cout<<" Xw "<<Xw<<endl;
smatrix test1=oplus(FCAB,Xu);
smatrix test2=oplus(FCAR,Xw);
if ((test1==Xu) && (test2==Xw))
    {
        cout<<" the oberver-based controller yields a greater control than the output feedback control "<<endl;
        KoptLopt=otimes(Kopt,Lopt);
       cout<<" KoptLopt "<<KoptLopt<<endl;
cout<<" Fopt "<<Fopt<<endl;
getchar();

    }


}


smatrix PFCAB=otimes(Popt_causal,FCAB);
smatrix PFCAB_s=star(PFCAB);
smatrix FCABP_sP=otimes(PFCAB_s,Popt_causal);

cout<<" H_{uv}(P,F) "<<FCABP_sP<<endl;


smatrix  ABP=otimes(AB,Popt_causal);
smatrix KABP=otimes(Kopt,ABP);
smatrix  KABP_s=star(KABP);

smatrix PKABP_s=otimes(Popt_causal,KABP_s);

cout<<" T_{uv}(P,M) "<<PKABP_s<<endl;

cout<<" Popt "<<Popt_causal<<endl;
 KoptLopt=otimes(Kopt,Lopt);
cout<<" KoptLopt "<<KoptLopt<<endl;
cout<<" Fopt "<<Fopt<<endl;

if(!(Fopt==KoptLopt))
{
    cout<<"A"<<A<<endl;
    i=1001;
    getchar();

}
else
{
    cout<<" Equality "<<endl;
   // getchar();

}


	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
