#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Observer Synthesis, Example taken from paper
[2] "Observer Design for max,+ linear systems
(IEEE TAC, 2010, Hardouin, Maia, Cottenceau, Lhommeau)
// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A(3,3);	// matrice d'tat

	smatrix L,L1,L2;
	int i,j;

	smatrix CA,AB,CAB,AR,CAR;


	A(0,0)=gd(1,4);//(g^1,d^4)
	A(0,1)=gd(0,1);//
	A(0,2)=gd(0,6);

	A(1,0)=gd(2,0);
    A(1,1)=gd(1,2);

	A(2,2)=gd(1,3);

	smatrix C(2,3);	// output matrix only coefficient on diagonl equal to e or epsilon

    C(0,0)=gd(0,0);
    C(1,2)=gd(0,0);
    smatrix B(3,2);	// matrice entre et sortie, epsilon everywhere
	B(1,0)=gd(0,0);
	B(2,1)=gd(0,0);
	smatrix R(3,3);
	R(0,0)=gd(0,0);
	R(1,1)=gd(0,0);
    R(2,2)=gd(0,0);

	smatrix As=star(A);
	CA=otimes(C,As);  // CA*

    AB=otimes(As,B);
    CAB=otimes(C,AB);
    AR=otimes(As,R);
    CAR=otimes(C,AR);

	L1=rfrac(AB,CAB);
	L2=rfrac(AR,CAR);
	L=inf(L1,L2);
	L=prcaus(L);

cout<<"As"<<As<<endl;
cout<<"L "<<L<<endl;
/// Data extraction for students of Rafael Santos Mendes
int k;
for (i=0;i<L.getrow();i++)
{for(j=0;j<L.getcol();j++)
{ printf("L(%d,%d).p =",i,j);
 for (k=0;k<L(i,j).getp().getn();k++)
 {
   printf("%d,%d", L(i,j).getp().getpol(k).getg(),L(i,j).getp().getpol(k).getd());


 }
 printf("\n");
 printf("L(%d,%d).q =",i,j);
 for (k=0;k<L(i,j).getq().getn();k++)
 {
   printf("%d,%d", L(i,j).getq().getpol(k).getg(),L(i,j).getq().getpol(k).getd());


 }
 printf("\n");
 printf("L(%d,%d).r =",i,j);
 printf("%d,%d", L(i,j).getr().getg(),L(i,j).getr().getd());



 printf("\n");
}
}



	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
