#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/*Example : Observer Synthesis, Example taken from paper
[1] duality between invariant spaces for max-plus  linear discrete event systems
arXiv:0901.2915v1 (authors DiLoreto, Gaubert, Katz, Loiseau)

Here the Synthesis is done thanks to results in
[2] "Observer Design for max,+ linear systems"
(IEEE TAC, 2010, Hardouin, Maia, Cottenceau, Lhommeau)
[3] "Max-plus Linear Observer: Application to Manufacturing Systems"
(Wodes 2010, Hardouin, Maia, Cottenceau, Santos Mendes)

This example compute the observer with result of [2] and also it gives the estimated states
obtained by considering the results of [1]
it appears that 4 transitions are correctly estimated, in spite of disturbances, by considering result of [1]
and they are the same than the one obtained by considering results in [2].
In [2] we obtain also an estimation for the other states, in the paper [3] it is shown that the error \hat{x}(k)-x(k) is
bounded

// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A(9,9);	// matrice d'tat
    smatrix AMean(9,9);	// matrice d'tat

	smatrix L,L1,L2;
	int i,j;

	smatrix CA,AB,CAB,AR,CAR;
    smatrix U(6,6);
    smatrix V(6,3);
    smatrix Zinitial(6,1);
    smatrix Z(6,3);

U(0,2)=gd(1,2);
U(1,0)=gd(1,4);
U(2,1)=gd(1,4);
U(2,3)=gd(1,3);
U(4,2)=gd(1,2);
U(5,0)=gd(1,4);

V(0,0)=gd(1,4);
V(1,1)=gd(1,3);
V(3,1)=gd(1,2);
V(3,2)=gd(1,4);
V(4,0)=gd(1,4);
V(5,1)=gd(1,3);

Z=star(U);
Z=otimes(Z,V);
cout<<" Z "<<Z<<endl;
 for(i=0;i<6;i++)
{
    {
Zinitial(i,0)=gd(0,0);
    }
}
smatrix Xinitial(9,1);
for(i=0;i<9;i++)
{
    {
Xinitial(i,0)=gd(0,0);
    }
}

	A(0,2)=gd(1,4);//(1,4)
	A(0,6)=gd(1,2);//(1,2)

	A(1,0)=gd(1,1);
	A(1,7)=gd(1,3);

	A(2,1)=gd(1,5);
	A(2,8)=gd(1,1);

	A(3,0)=gd(1,4);
	A(3,5)=gd(1,3);

	A(4,1)=gd(1,3);
	A(4,3)=gd(1,1);

	A(5,2)=gd(1,5);
	A(5,4)=gd(1,4);

	A(6,3)=gd(1,4);
	A(6,8)=gd(1,3);

	A(7,6)=gd(1,5);
	A(7,4)=gd(1,3);

    A(8,7)=gd(1,4);
	A(8,5)=gd(1,2);

    AMean=A;
   // A(1,0)=gd(1,4);
  //  A(4,1)=gd(1,2);
  //  A(4,3)=gd(1,4);

	smatrix C(9,9);	// output matrix only coefficient on diagonl equal to e or epsilon

   // C(0,0)=gd(0,0);
    //C(1,1)=gd(0,0);
 	C(2,2)=gd(0,0); // in paper [1] the first sensor is her
	//C(3,3)=gd(0,0);
    //C(4,4)=gd(0,0);
	C(5,5)=gd(0,0); // in paper [1] the second sensor is here
    //C(6,6)=gd(0,0);
	C(7,7)=gd(0,0); // in paper [1] the third sensor is here
    //C(8,8)=gd(0,0);
	/* */
// test we can change the position of sensors to achieve the equality, you have to comment the previous three
// line and to replace by the following one : in this case all the sate are perfectly estimated
// since the sufficient condition of proposition 4 of paper [2], see reference in the head, is fulfilled
/*	C(1,1)=gd(0,0);
	C(4,4)=gd(0,0);
	C(7,7)=gd(0,0);
*/
    smatrix B(9,1);	// matrice entre et sortie, epsilon everywhere
	smatrix R(9,3);
	R(1,0)=gd(0,0);
	R(4,1)=gd(0,0);
    R(1,0)=gd(0,0);

	smatrix As=star(A);
	CA=otimes(C,As);  // CA*

    AB=otimes(As,B);
    CAB=otimes(C,AB);
    AR=otimes(As,R);
    CAR=otimes(C,AR);
      cout<<" AB "<<AB<<endl;
       cout<<" CAB "<<CAB<<endl;
	L1=rfrac(AB,CAB);

	L2=rfrac(AR,CAR);
	L=inf(L1,L2);
	L=prcaus(L);
    cout<<" L2 "<<L2<<endl;

    getchar();

    smatrix X;
    smatrix Xestim;
    smatrix ALCA,LC,LCA,LCs,ALCAR;
    serie SSL,SSR;
    smatrix Asup=A;

    Asup(1,0)=gd(1,7);
    Asup(4,1)=gd(1,5);
    Asup(4,3)=gd(1,3);
    smatrix ASsup=star(Asup);
    As=star(AMean);
    X=ASsup;
    cout<<" X = AsupR"<<X<<endl;
    LC=otimes(L,C);
    LCA=otimes(LC,ASsup);
    LCs=oplus(LC,As);
    LCs=star(LCs);
    ALCA=otimes(LCs,LCA);
    ALCAR=ALCA;

    if (ALCAR==X) cout<<" it is OK"<<endl;


	cout << "Xestim :" << ALCAR << endl;
    cout << "X :" << X << endl;
   for(i=0;i<9;i++)
   { for (j=0;j<3;j++)
   {
    if (ALCAR(i,j)==X(i,j))
    cout<<"equality between x"<<i+1<<"and xestimate"<<i+1<<endl; // that means x and xestimate will be equal whatever be the disturbance
    else {
        cout<<"NO equality for transition labelled :"<<i+1<<endl; // for these transition equality is not achieved but the best is done
        cout<<"It is due to  difference between AsupR("<<i+1<<","<<j+1<<") "<<X(i,j)<<endl;
        cout<<"and ALCAR("<<i+1<<","<<j+1<<") "<<ALCAR(i,j)<<endl;

        SSL=inf(ALCAR(i,j),X(i,j));
        SSR=oplus(X(i,j),ALCAR(i,j));

        serie SSLL=frac(SSL,SSR);
        serie SSRR=frac(SSR,SSL);
        cout<<" SSRR "<<SSRR<<endl;
        cout<<" SSLL "<<SSLL<<endl;

    }
   }
   }

if (ALCAR==X) cout<<" it is OK"<<endl;

	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
