#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Observer Synthesis, Example taken from paper
[1] arXiv:0901.2915v1 (authors DiLoreto, Gaubert Katz, Loiseau
Synthesis down thanks to results in
[2] "Observer Design for max,+ linear systems
(IEEE TAC, 2010, Hardouin, Maia, Cottenceau, Lhommeau)



// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A(9,9);	// matrice d'tat

	smatrix L,L1,L2; // observer matrices with objective x=xest
	smatrix LBis,L1Bis,L2Bis; // observer matrices with objective (x,xest) in Ker C
	int i,j;

	smatrix CA,AB,CAB,AR,CAR;


	A(0,2)=gd(1,4);//(1,4)
	A(0,6)=gd(1,2);//(1,2)

	A(1,0)=gd(1,1);
	A(1,7)=gd(1,3);

	A(2,1)=gd(1,5);
	A(2,8)=gd(1,1);

	A(3,0)=gd(1,4);
	A(3,5)=gd(1,3);

	A(4,1)=gd(1,3);
	A(4,3)=gd(1,1);

	A(5,2)=gd(1,5);
	A(5,4)=gd(1,4);

	A(6,3)=gd(1,4);
	A(6,8)=gd(1,3);

	A(7,6)=gd(1,5);
	A(7,4)=gd(1,3);

    A(8,7)=gd(1,4);
	A(8,5)=gd(1,2);


	smatrix C(3,9);	// matrice entre et sortie

 	C(0,2)=gd(0,0);
	C(1,5)=gd(0,0);
	C(2,7)=gd(0,0);
	/* */
// test we can change the position of sensors to achieve the equality, you have to comment the previous three
// line and to replace by the following one : in this case all the sate are perfectly estimated
// since the sufficient condition of proposition 4 of paper [2], see reference in the head, is fulfilled
/*	C(0,1)=gd(0,0);
	C(1,4)=gd(0,0);
	C(2,7)=gd(0,0);
*/
    smatrix B(9,1);	// matrice entre et sortie, epsilon everywhere
	smatrix R(9,3);
	R(1,0)=gd(0,0);
	R(4,1)=gd(0,0);
    R(1,0)=gd(0,0);

	smatrix As=star(A);
	CA=otimes(C,As);  // CA*

    AB=otimes(As,B);
    CAB=otimes(C,AB);
    AR=otimes(As,R);
    CAR=otimes(C,AR);

	L1=rfrac(AB,CAB);
	L2=rfrac(AR,CAR);
	L=inf(L1,L2);
	L=prcaus(L); // matrix with objecive xest==x

	L1Bis=rfrac(CAB,CAB);
	L1Bis=lfrac(L1Bis,CA);
	L2Bis=rfrac(CAR,CAR);
	L2Bis=lfrac(L2Bis,CA);
	LBis=inf(L1Bis,L2Bis);
	LBis=prcaus(LBis); // matrix with objecive (xest,x) in Ker C


    smatrix X;
    smatrix Xestim;
    smatrix ALCA,LC,LCA,LCs,ALCAR;
    smatrix ALCABis,LCBis,LCABis,LCsBis,ALCARBis;
    X=AR;
    cout<<" X = AR"<<X<<endl;
    // computation with observer L, ie with objective xest==x
    LC=otimes(L,C);
    LCA=otimes(LC,As);
    LCs=oplus(LC,A);
    LCs=star(LCs);
    ALCA=otimes(LCs,LCA);
    ALCAR=otimes(ALCA,R);

    if (ALCAR==AR) cout<<"The estimate state is equal to the real state with L=((AB)/(CAB))^((AR)/(CAR)) "<<endl;


	cout << "Xestim :" << ALCAR << endl;
    cout << "X :" << AR << endl;
   for(i=0;i<9;i++)
   { for (j=0;j<3;j++)
   {
    if (ALCAR(i,j)==AR(i,j))
    cout<<"equality between x"<<i+1<<"and xestimate"<<i+1<<endl; // that means x and xestimate will be equal whatever be the disturbance
    else {
        cout<<"NO equality for transition labelled :"<<i+1<<endl; // for these transition equality is not achieved but the best is done
        cout<<"It is due to  difference between AR("<<i<<","<<j<<") "<<AR(i,j)<<endl;
        cout<<"and ALCAR("<<i<<","<<j<<") "<<ALCAR(i,j)<<endl;
    }
   }
   }


// computation with observer LBis, ie with objective (xest,x) in Ker C
    LCBis=otimes(LBis,C);
    LCABis=otimes(LCBis,As);
    LCsBis=oplus(LCBis,A);
    LCsBis=star(LCsBis);
    ALCABis=otimes(LCsBis,LCABis);
    ALCARBis=otimes(ALCABis,R);

      if (ALCARBis==AR) cout<<"The estimate state is equal to the real state with LBis=((CA)\(CAB)/(CAB))^((CA)\(CAR)/(CAR)) "<<endl;


	cout << "XestimBis :" << ALCARBis << endl;

   for(i=0;i<9;i++)
   { for (j=0;j<3;j++)
   {
    if (ALCARBis(i,j)==AR(i,j))
    cout<<"equality between x"<<i+1<<"and xestimate"<<i+1<<endl; // that means x and xestimate will be equal whatever be the disturbance
    else {
        cout<<"NO equality for transition labelled :"<<i+1<<endl; // for these transition equality is not achieved but the best is done
        cout<<"It is due to  difference between AR("<<i<<","<<j<<") "<<AR(i,j)<<endl;
        cout<<"and ALCARBis("<<i<<","<<j<<") "<<ALCARBis(i,j)<<endl;
    }
   }
   }

    if (L==LBis)
    cout<<"the both observers are the same"<<endl;
    else
    {if (ALCAR==ALCARBis)    cout<<" the two estimate state are the same"<<endl;
     else
     { cout<<" the obervers nor the state are the same"<<endl;
     }
    }




cout<<"CA "<<CA<<endl;
	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
