#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Observer Synthesis, Example taken from paper
[1] duality between invariant spaces for max-plus  linear discrete event systems
arXiv:0901.2915v1 (authors DiLoreto, Gaubert, Katz, Loiseau)

Here the Synthesis is done thanks to results in
[2] "Observer Design for max,+ linear systems"
(IEEE TAC, 2010, Hardouin, Maia, Cottenceau, Lhommeau)
[3] "Max-plus Linear Observer: Application to Manufacturing Systems"
(Wodes 2010, Hardouin, Maia, Cottenceau, Santos Mendes)

This example compute the observer with result of [2] and also it gives the estimated states
obtained by considering the results of [1]
it appears that 4 transitions are correctly estimated, in spite of disturbances, by considering result of [1]
and they are the same than the one obtained by considering results in [2].
In [2] we obtain also an estimation for the other states, in the paper [3] it is shown that the error \hat{x}(k)-x(k) is
bounded



// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A(9,9);	// matrice d'tat

	smatrix L,L1,L2;
	int i,j;

	smatrix CA,AB,CAB,AR,CAR;


	A(0,2)=gd(1,4);//(1,4)
	A(0,6)=gd(1,2);//(1,2)

	A(1,0)=gd(1,1);
	A(1,7)=gd(1,3);

	A(2,1)=gd(1,5);
	A(2,8)=gd(1,1);

	A(3,0)=gd(1,4);
	A(3,5)=gd(1,3);

	A(4,1)=gd(1,3);
	A(4,3)=gd(1,1);

	A(5,2)=gd(1,5);
	A(5,4)=gd(1,4);

	A(6,3)=gd(1,4);
	A(6,8)=gd(1,3);

	A(7,6)=gd(1,5);
	A(7,4)=gd(1,3);

    A(8,7)=gd(1,4);
	A(8,5)=gd(1,2);


	smatrix C(9,9);	// output matrix only coefficient on diagonl equal to e or epsilon

   // C(0,0)=gd(0,0);
    //C(1,1)=gd(0,0);
 	C(2,2)=gd(0,0); // in paper [1] the first sensor is her

	//C(3,3)=gd(0,0);
    //C(4,4)=gd(0,0);
	C(5,5)=gd(0,0); // in paper [1] the second sensor is here
    //C(6,6)=gd(0,0);
	C(7,7)=gd(0,0); // in paper [1] the third sensor is here
    //C(8,8)=gd(0,0);
	/* */
// test : we can change the position of sensors to achieve the equality, you have to comment the previous three
// line and to replace by the following one : in this case all the sate are perfectly estimated
// since the sufficient condition of proposition 4 of paper [2], see reference in the head, is fulfilled
	//C(1,1)=gd(0,0);
	//C(4,4)=gd(0,0);


    smatrix B(9,1);	// matrice entre et sortie, epsilon everywhere
	smatrix R(9,3);
	R(1,0)=gd(0,0);
	R(4,1)=gd(0,0);
    //R(1,0)=gd(0,0);

	smatrix As=star(A);
	CA=otimes(C,As);  // CA*

    AB=otimes(As,B);
    CAB=otimes(C,AB);
    AR=otimes(As,R);
    CAR=otimes(C,AR);

	L1=rfrac(AB,CAB);
	L2=rfrac(AR,CAR);

	L=inf(L1,L2);
	L=prcaus(L); // the observer matrix


    smatrix X;
    smatrix Xestim;
    smatrix ALCA,LC,LCA,LCs,ALCAR;
    X=AR; // transfer function between uncontrollable inputs and state
    cout<<" X = AR"<<X<<endl;
    LC=otimes(L,C);
    LCA=otimes(LC,As);
    LCs=oplus(LC,A);
    LCs=star(LCs);
    ALCA=otimes(LCs,LCA);
    ALCAR=otimes(ALCA,R);  // transfer function between uncontrollable inputs and estimate state

    if (ALCAR==AR) cout<<" it is OK"<<endl; // if these matrices are equal, the system is perfectly observable
    else if(oplus(ALCAR,AR)==AR)  cout<<" State is greater than or equal to estimated state"<<endl;
serie s1,s2;
	cout << "Xestim :\n" << ALCAR << endl;
    cout << "X :\n" << AR << endl;
   for(i=0;i<9;i++)
   { for (j=0;j<3;j++)
   {
    if (ALCAR(i,j)==AR(i,j))
    cout<<"equality between x"<<i+1<<"and xestimate"<<i+1<<endl; // that means x_i and xestimate will be equal whatever be the uncontrollable input q_j
    else {
        cout<<"NO equality for transition labelled :"<<i+1<<endl; // for these transition equality is not achieved but the best is done
        cout<<"It is due to  difference between AR("<<i+1<<","<<j+1<<") "<<AR(i,j)<<endl;
        cout<<"and ALCAR("<<i+1<<","<<j+1<<") "<<ALCAR(i,j)<<endl;
    /* computation in order to get the bounds for the difference \{x}(k)-x(k) when there are errors.*/
        s1=frac(ALCAR(i,j),AR(i,j));
        s2=frac(AR(i,j),ALCAR(i,j));
        cout<<" For upper bound of the difference, Residuation ALCAR("<<i+1<<","<<j+1<<") by  AR("<<i+1<<","<<j+1<<") :\n"<<s1<<endl;
        cout<<" For lower bound of the difference, Residuation AR("<<i+1<<","<<j+1<<") by  ALCAR("<<i+1<<","<<j+1<<") :\n"<<s2<<endl;
    }
   }
   }
       if (ALCAR==AR) cout<<" it is OK"<<endl;

// To save in a file the results
ofstream myfile;
  myfile.open ("ObserverMatrixL.txt");
  myfile <<"L"<<L<<endl;
  myfile.close();

cout<<"L \n"<<L<<endl;
printf("Press Enter to Continue \n");
fflush(stdin);
getchar();

	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
