#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Automatica 2001, to appear
           "Model reference control for timed event graphs in dioids"
// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the following files
//
*/
#include "..\..\src\gd.cpp"
#include "..\..\src\poly.cpp"
#include "..\..\src\serie.cpp"
#include "..\..\src\smatrix.cpp"
#include "..\..\src\tools.cpp"
using namespace std;
using namespace mmgd;
/////////////////////////////////////////////////////////////////////


int main()
{
try
{
/////////////////////////////////////////////////////////////////////
// Backward Equations , Optimal control \\
/////////////////////////////////////////////////////////////////////
 poly p;
 int n=5;
 gd tab[n];
 serie s[n];
 tab[0].init(6,12);
 tab[1].init(7,14);
 tab[2].init(11,22);
 tab[3].init(16,32);
 tab[4].init(17,34);
    p(6,12)(7,14)(11,22)(16,32)(17,34);
    cout << p << endl;

 for(int i=0;i<n;i++)
 {
     s[i]=star(tab[i]);
 }
 serie result=s[0];
for(int i=0;i<n;i++)
 {
     result=otimes(result,s[i]);
     cout<<"result p "<<result.getp().getn()<<" q "<<result.getq().getn()<<" r "<<result.getr()<<endl;
     cout<<"result "<<result<<endl;
 }

 result=star(p);
 cout << result << endl;

	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement

	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
 catch(const char * s)
 { cout<<"Exception  "<<s<<endl;
	 return(1);

 }

}
