#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Observer Synthesis, Example taken from paper
[1] arXiv:0901.2915v1 (authors DiLoreto, Gaubert Katz, Loiseau
Synthesis down thanks to results in
[2] "Observer Design for max,+ linear systems
(IEEE TAC, 2010, Hardouin, Maia, Cottenceau, Lhommeau)



// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"
#include <time.h>

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A(9,9);	// matrice d'tat
    smatrix R(9,9);	// matrice de perturbation
    smatrix C(9,9);	// matrice de sorie
	smatrix L,L1,L2;
	int i,j;
	int n,d,k;

	smatrix CA,AB,CAB,AR,CAR,ALCAR;
 srand(time(NULL));
   for (i=0;i<9;i++)
   {
   for (j=0;j<9;j++)
   { n=rand()%20;
     d=rand()%20;
     A(i,j)=gd(n,d);
   }
    k=rand()%8;

    if(k==1)
    {
    k=rand()%9;
    C(i,k)=gd(0,0);
    R(k,i)=gd(0,0);

    }
   }




	smatrix As=star(A);
	CA=otimes(C,As);  // CA*

    AR=otimes(As,R);
    CAR=otimes(C,AR);
    L=rfrac(AR,CAR);
    ALCAR=otimes(L,CAR);



   for(i=0;i<9;i++)
   { for (j=0;j<3;j++)
   {
    if (ALCAR(i,j)==AR(i,j))
    cout<<"equality between x"<<i+1<<"and xestimate"<<i+1<<endl; // that means x and xestimate will be equal whatever be the disturbance
    else {
        cout<<"NO equality for transition labelled :"<<i+1<<endl; // for these transition equality is not achieved but the best is done
        cout<<"It is due to  difference between AR("<<i<<","<<j<<") "<<AR(i,j)<<endl;
        cout<<"and ALCAR("<<i<<","<<j<<") "<<ALCAR(i,j)<<endl;
    }
   }
   }
  if (ALCAR==AR) cout<<" it is OK"<<endl;
	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficents in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carre uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
