#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>



/////////////////////////////////////////////////////////////////////
/* Example : Discrete Event Systems in Dioid Framework : Control Theory
 Laurent Hardouin, Olivier Boutin, Bertrand Cottenceau, Thomas Brunsch, Joerg Raisch
 Springer, DISC Book
This program compute :
1. the optimal control when a reference output is a priori known
2. the optimal input filtering when the reference output is unknown
3. the optimal feedback
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"


using namespace std;
using namespace mmgd;

int main(void)
{
try{


poly p;
p.init(10,7)(14,8)(15,11)(17,14)(19,16)(20,18);
poly q;
q.init(23,30)(26,34)(30,38)(31,41)(35,43)(38,46)(41,49)(42,53);
gd r;
r.init(22,25);
int i=330000;
poly ptest;
for(int j=0;j<i;j++)
{
    ptest.add(gd(j+2,j+1));
    if(j%10000==0)
        cout<<"ptest"<<ptest.getpol(j)<<endl;
}
ptest.simpli();
//cout<<"ptest ="<<ptest<<endl;
serie s,sstar,sstarstar;
s.init(p,q,r);
sstar=star(s);
cout<<"s"<<s<<endl;
cout<<"sstar"<<sstar<<endl;

poly qr;
qr=oplus(sstar.getr(),sstar.getq());
cout<<" qr " <<qr<<endl;

serie sqr;
sqr=star(qr);

sstarstar=star(sstar);

cout<<"sstarstar"<<sstarstar<<endl;
if (sstarstar==sstar)
{
    cout<<" starstar ok "<<endl;
}

//fstream f;

//  f.open("/home/brunsch/CAsB.txt",ios::out);
//f<<casb;
//f.close();

return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
