
#ifndef _WIN32
#include "lminmaxgd.h"
#include "matrixCOO.h"
#else
#include "lminmaxgd.h"
using namespace std;
#endif

#include <time.h>
#include <stdio.h>
// XavierTestCACABABStar.cpp :
// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
//
#include "gd.cpp"
#include "poly.cpp"
#include "serie.cpp"
#include "smatrix.cpp"
#include "matrixCOO.cpp"
#include "tools.cpp"




#define n 200
#define nI 4
#define nO 4

int main()

{
	try
	{
//**********************************************************************/
// this example check if
// CA\CAB/AB is a star
// After work with Xavier April 2012
//**********************************************************************/

double debut,fin;


    matrixCOO ACOO(n,n);
     matrixCOO BCOO(n,n);
     matrixCOO CCOO;
     matrixCOO DCOO;
	smatrix A(n,n);// matrix of series declaration
	smatrix B(n,n);
	smatrix C(n,n);
	smatrix Asn,An1;
	smatrix CAsn,AsBn;
	smatrix Hn;
	gd m; // monomial declaration
    int k,i,j,val,flag,boucle; //
    int d;
    serie s;
srand((int)(time(NULL)));
boucle=0;
val=6;
 int ratio=0;
 int na,nb;
for (k=0;k<20;k++) // nombre de boucles
{
ratio+=5;

std::cout<<"Taux remplissage "<<ratio<<" % : ";

nb=0;
na=0;

 for (i=0;i<n;i++)
 {
	 for (j=0;j<n;j++)    {
	      A(i,j)=epsilon;
                            B(i,j)=epsilon;


                            flag=rand()%100;


                            if(flag>=0&&flag<=ratio) // 1/ratio de chance d'avoir different de epsilon

							{  na++;
							//cout<<"flag"<<flag<<" na"<<na<<endl;

							    d=rand()%val; // dans [0,val-1]
							    A(i,j).init(epsilon,m.init(rand()%val,d),e);
							}
                                flag=rand()%100;
                            if(flag>=0&&flag<=ratio) // 50% de epsilon

							{
							    nb++;
							    d=rand()%val; // dans [0,val-1]
							    B(i,j).init(epsilon,m.init(rand()%val,d),e);
							}

							}



 }

            ACOO=A;
            BCOO=A;
            debut = ((float)clock());

            transpose(ACOO,DCOO);

           fin=((float)clock());
          std::cout<<"Taux : "<<(float)(na+nb)/(2*n*n)<<" At COO "<<(fin-debut)/CLOCKS_PER_SEC*1000<<" ms ";

            debut = ((float)clock());

                for (i=0;i<n;i++)
                    {
                        for (j=0;j<n;j++)
                        {
                             B(i,j)=A(j,i);
                        }
                    }
            //cout<<"ACOO"<<ACOO<<endl;
            //cout<<"DCOO"<<DCOO<<endl;
            fin=((float)clock());
            std::cout<<" At smatrix "<<" "<<(fin-debut)/CLOCKS_PER_SEC*1000<<" ms"<<std::endl;

            CCOO=B;

            if(DCOO==CCOO) {std::cout<<" OK"<<std::endl;}
else {
    std::cout<<"probleme "<<boucle<<std::endl;
   boucle++;
      getchar();
   std::cout<<"ACOO\n"<<ACOO<<std::endl;
   //std::cout<<"A\n"<<A<<std::endl;
   std::cout<<"BCOO\n"<<BCOO<<std::endl;
     //cout<<"B\n"<<B<<endl;
    std::cout<<"CCOO\n"<<CCOO<<std::endl;
     std::cout<<"DCOO\n"<<DCOO<<std::endl;



	}
}
	return 0;
}
catch(mem_limite l)
 {
 std::cout<<"Exception : too many coefficent in polynom "<<l.memoire<< std::endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
 std::cout<<"Exception  "<<obj.erreur<< std::endl;
	 return(1);
 }

}
