#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Automatica 2001, to appear
           "Model reference control for timed event graphs in dioids"
// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
//
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A(1,1);	// matrice d'tat

	smatrix H(1,1);

	smatrix CA(1,1);


	A(0,0)=gd(3,15);//(1,2)

	smatrix B(1,1),C(1,1);	// matrice entre et sortie

	C(0,0)=gd(0,0);

	B(0,0)=gd(0,15);	// x1=u1


	smatrix As=star(A);
	CA=otimes(C,As);  // CA*
    cout << "CA* :" << CA << endl;

	H=otimes(CA,B); // input/output transfer CA*B
	cout << "H :" << H << endl;

	smatrix u;
	smatrix z(1,1);
	poly p;
	gd m;
	p.init(0,0)(1,2);
	z(0,0).init(p,p,m.init(0,0));

    u=lfrac(z,H);

    cout<<"z"<<z<<endl;
    cout<<"u"<<u<<endl;

	smatrix A1(1,1);	// matrice d'tat

	smatrix H1(1,1);

	smatrix CA1(1,1);


	A1(0,0)=gd(2,10);//(1,2)

	smatrix B1(1,1),C1(1,1);	// matrice entre et sortie

	C1(0,0)=gd(0,0);

	B1(0,0)=gd(0,10);	// x1=u1

	smatrix As1=star(A1);
	CA1=otimes(C1,As1);  // CA*
    cout << "CA*1 :" << CA1 << endl;

	H1=otimes(CA1,B1); // input/output transfer CA*B
	cout << "H1 :" << H1 << endl;




	smatrix u1;


    u1=lfrac(z,H1);

    cout<<"z"<<z<<endl;
    cout<<"u1"<<u1<<endl;



	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
