#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>




/////////////////////////////////////////////////////////////////////
/* Example :

*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

int main()
{
try
{
    smatrix C(3,3), D(3,3);
    smatrix X1,X0(3,1);
    gd m, n(0,5), ep;
    poly k;
    ep = epsilon;

    C(0,0)=gd(0,2);
    C(0,1)=gd(0,5);

    C(1,0)=gd(0,2);
    C(1,1)=gd(0,7);
    C(1,2)=gd(0,7);
    C(2,0)=gd(0,7);
    C(2,1)=gd(0,9);
    C(2,2)=gd(0,1);

    D(0,0)=gd(0,1);
    D(0,1)=gd(0,4);
    D(0,2)=gd(0,4);
    D(1,0)=gd(0,6);
    D(1,1)=gd(0,3);
    D(1,2)=gd(0,1);
    D(2,0)=gd(0,2);
    D(2,1)=gd(0,5);
    D(2,2)=gd(0,8);

    X0(0,0)=gd(0,15);
    X0(1,0)=gd(0,15);
    X0(2,0)=gd(0,15);
  cout<<"C"<<C<<endl;
  cout<<"D"<<D<<endl;
  cout<<"X0"<<X0<<endl;
    smatrix CX, DX, DCX, CDX;
    X1=X0;
    do
    {   X0=X1;
        CX=otimes(C,X0);
        cout<<"CX"<<CX<<endl;
        DX=otimes(D,X0);
        cout<<"DX"<<DX<<endl;
        DCX=lfrac(CX,D);
        cout<<"DCX"<<DCX<<endl;
        CDX=lfrac(DX,C);
        cout<<"CDX"<<CDX<<endl;
        X1=inf(X0,DCX);
        X1=inf(X1,CDX);
        cout<<"X1"<<X1<<endl;
        getchar();
    }
    while(!(X0==X1));

    cout<<"FINI"<<endl;

	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
