#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>




/////////////////////////////////////////////////////////////////////
/* Example :

*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

int main()
{
try
{   smatrix C(3,4);
    smatrix CC;
    smatrix A(4,4), A_star(4,4);
    smatrix CA, CCAs, CCAsbis;
    gd m, n(0,5), ep;
    poly k;
    ep = epsilon;

     C(0,0).init(ep,k.init(0,0),m.init(0,0));
     C(1,2).init(ep,k.init(0,0),m.init(0,0));

     CC=lfrac(C,C);
     cout<<"CC"<<CC<<endl;

    A(0,2).init(ep,k.init(1,5),m.init(1,4));
    A(1,0).init(ep,k.init(2,3),m.init(1,3));
    A(2,1).init(ep,k.init(0,6),m.init(1,5));
    A(3,1).init(ep,k.init(0,1),m.init(1,5));
    A(0,3).init(ep,k.init(0,1),m.init(1,5));
    cout<<"A = "<< A <<endl;

    A_star = star(A);
    cout<<"A_Star = "<< A_star <<endl;

    CA=otimes(C,A_star);
    CCAs=lfrac(CA,C);
    cout<<"CCAs"<<CCAs<<endl;
    CCAsbis=otimes(CC,A_star);
    cout<<"CCAs"<<CCAsbis<<endl;

    if(CCAsbis==CCAs) cout<<" it seems OK"<<endl;



	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
