#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
#include <time.h>




/////////////////////////////////////////////////////////////////////
/* Example : Discrete Event Systems in Dioid Framework : Control Theory
 Laurent Hardouin, Olivier Boutin, Bertrand Cottenceau, Thomas Brunsch, Joerg Raisch
 Springer, DISC Book
This program compute :
1. the optimal control when a reference output is a priori known
2. the optimal input filtering when the reference output is unknown
3. the optimal feedback
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"
#define N 5
using namespace std;

int main(void)
{
try{
clock_t start, finish;
srand(time(NULL));
//struct rusage ru;
clock_t duration,duration2;
poly p1;
poly p2,p3,p4;
smatrix A(N,N);
smatrix B(N,N);
smatrix AS;
int i,j;
int n0=_infinity,t0=_infinity;
int n,t;
gd r;
 n0=rand()%(10);
t0=rand()%(1000);

for (i=0;i<N;i++)
{
    for(j=0;j<N;j++)
    { t0=rand()%(1000);
    n0=rand()%(1);
        A(i,j).init(epsilon,r.init(n0,t0),e);
        B(i,j).init(epsilon,r.init(n0,t0),e);
    }
}

system("pause");
start = clock();

AS=star(A);
finish=clock();
duration = (finish - start) ;
printf( "%f clock for p3\n", (float)duration );
system("pause");
B=otimes(AS,AS);
if(B==AS) cout<<"Computation ok otimes"<<endl;
B=lfrac(AS,AS);
if(B==AS) cout<<"Computation ok lfrac"<<endl;
B=rfrac(AS,AS);
if(B==AS) cout<<"Computation ok rfrac"<<endl;

smatrix Ap,ASp,P,PT;

start = clock();
P=permutation(A);
ASp=star(A);
finish=clock();
duration2 = (finish - start) ;
printf( "%f clock for A %f clock for ASp\n", (float)duration , (float)duration2 );
system("pause");
ASp=otimes(ASp,P);

PT=transpose(P);
ASp=otimes(PT,ASp);
if(AS==ASp)
{cout<<"ok"<<endl;
system("pause");
}
else
{
    cout<<"pb Asp noteq AS"<<endl;
}


//out<<"AS"<<AS<<endl;
start = clock();

//cout<<"AS= "<<AS<<endl;
return(0);
 }
  catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
