#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Automatica 2001, to appear
           "Model reference control for timed event graphs in dioids"
// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
//*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A0(5,5);	// matrice d'tat
    smatrix A1(5,5);
	smatrix B(5,1);


	A1(1,0)=gd(1,1);//(1,2)
	A0(2,1)=gd(0,2);
	A1(3,2)=gd(1,4);
	A0(4,3)=gd(0,9);
	A1(0,1)=gd(1,2);

	B(0,0)=gd(0,0);



	smatrix As=star(A0);
	cout << "A0 *:" << As << endl;
	//As=otimes(As,A1);
	smatrix B1=otimes(As,B);  // CA*
    cout << "A0:" << A0 << endl;

    cout << "A0*B :" << B1 << endl;

    //smatrix A1s=star(A1);
   smatrix A1s=otimes(As,A1);
    cout << "A0*A1* :" << A1s << endl;
    A1s=star(A1s);
    smatrix ABs=otimes(A1s,B1);
       cout << "ABs :" << ABs << endl;
system("cls");

A1s=otimes(As,A1);

smatrix AB=otimes(A1s,B1);
cout<<AB<<endl;
smatrix C=oplus(AB,B1);

smatrix An=A1s;
cout<<C<<endl;
int i;
for (i=1;i<3;i++)
    {An=otimes(An,A1s);
    AB=otimes(An,B1);
     C =oplus(AB,C);cout<<"C"<<C<<endl;
    }

system("cls");
smatrix Bb(5,2);
smatrix Aa(5,5);
Bb(0,0)=gd(0,0);
Bb(1,1)=gd(0,0);
Aa(0,0)=gd(0,1);
Aa(1,1)=gd(0,2);
Aa(2,0)=gd(0,0);
Aa(2,1)=gd(0,0);
Aa(3,1)=gd(0,0);
Aa(4,2)=gd(0,0);



smatrix Aas(5,5);
Aas=star(Aa);
cout<<" Aas"<<Aas<<endl;
int n=Aas(4,2).getq().getpol(0).getd();
cout<<"n"<<n;

float rho=-1000;
float rhoi;
smatrix At(5,5);
serie sdiag;

gd diag;
for (i=0;i<5;i++)
{ At(i,i)=gd(0,0);
}
for(int j=1;j<6;j++)
{


At=otimes(At,Aa);
sdiag=eps;
for (i=0;i<5;i++)
{
  //cout<<"sdiag "<<sdiag<<endl;
  //cout<<"At"<<At(i,i);
    sdiag=oplus(sdiag,At(i,i));
}
    diag=sdiag.getq().getpol(0);
    rhoi=(float)diag.getd()/j;
  //  cout<<"rhoi "<<rhoi<<endl;
    if (rhoi>rho) rho=rhoi;

}
//cout<<"rho "<<rho;
smatrix B2(3,1);
smatrix A2(3,3);
smatrix As2;
B2(2,0)=gd(0,0);

A2(0,1)=gd(0,-3);
A2(1,1)=gd(0,-1);
A2(1,2)=gd(0,6);
As2=star(A2);
smatrix F2;

F2=lfrac(As2,B2);
cout<<"F2"<<F2<<endl;

	return(0);
}




 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
