#ifndef _WIN32
#include "../include/lminmaxgd.h"
#else
#include "..\include\lminmaxgd.h"
using namespace std;
#endif
/////////////////////////////////////////////////////////////////////
/* Example : Automatica 2001, to appear
           "Model reference control for timed event graphs in dioids"
// you must link with a library which contains all source files given in folder src
// gd.cpp poly.cpp serie.cpp smatrix.cpp tools.cpp interf.cpp
// or add these files in your project
// or alternatively you can include the folowing files
*/
#include "..\src\gd.cpp"
#include "..\src\poly.cpp"
#include "..\src\serie.cpp"
#include "..\src\smatrix.cpp"
#include "..\src\tools.cpp"

/////////////////////////////////////////////////////////////////////


int main()
{
try
{

	smatrix A(5,5);	// matrice d'tat


	A(0,1)=gd(1,0);//(1,2)
	A(0,4)=gd(2,0);//(1,2)
	A(1,0)=gd(0,2);
	A(2,1)=gd(0,3);
	A(3,1)=gd(-1,0);
	A(3,2)=gd(0,0);
    A(3,4)=gd(1,0);
	A(4,3)=gd(0,2);

	smatrix B(3,2),C(1,3);	// matrice entre et sortie

	C(0,2)=gd(0,2);

	B(0,0)=e;	// x1=u1
	B(1,1)=e;	// x6=u2
    smatrix Apower(5,5);

	smatrix As=star(A);

	cout << "A* :" << As << endl;
	int i;
	for (i=0;i<5;i++)
	{ Apower(i,i)=gd(0,0);
	}
	smatrix tampon=Apower;
	for (i=0;i<12;i++)
	{ tampon=otimes(tampon,A);
	  Apower=oplus(Apower,tampon);
	  cout << "Apower :" << Apower << endl;
	}

    smatrix Other(2,2);
    Other(0,1)=gd(2,1);
    Other(1,0)=gd(-1,5);

	return(0);
}

 catch(mem_limite l)
 {
	 cout<<"Exception : too many coefficent in polynom "<<l.memoire<<endl;
	 return(1);
 }

 catch(taille_incorrecte obj)
 { // 0 : r non causal
   // 1 : tentative d'accs  un element d'une matrice avec un indice incorrect
   // 2 : matrice de taille incompatible pour oplus, inf, otimes, rfrac, lfrac
   // 3 : etoile de matrice carr uniquement
	 cout<<"Exception  "<<obj.erreur<<endl;
	 return(1);
 }
}
